#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Aurora flowerMod01.fsh   by   WdFGeorge
//https://www.shadertoy.com/view/......
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float flower(float t, float a, float b, float c, float d, float f)
{   
    return (a + (b * cos(c * t)) / (d + abs(sin(f * t))));   
}


float sigma_delta(float a, float b)
{
    return 1.0 - 1.0 / (1.0 + exp(1.0 * (-abs(a - b) + 4.0)));
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) {
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{

{
    const float flower_scale = 4.72;
    const float flower_amp = 2.0;
    const float flower_count = 20.0;
    const float flower_amp_in = 0.284;
    const float flower_count_in = 6.84;
    
    
    float k_time = sin(iTime * 0.5) * 0.5 + 0.5;

    vec2 pos = fragCoord/iResolution.xy * 2.0 - 1.0;
    pos.x *= iResolution.x / iResolution.y;
    pos *= 32.0;
    float t = atan(pos.x, pos.y);
    float r0 = length(pos);
    float rn = 4.0;
    float rf = flower(t,
                      14.0,
                      -2.0,
                      rn * k_time,
                      0.1,
                      2.0 * rn * (1.0 - k_time));
    float gn = 6.0;
    float gf = flower(t,
                      10.0,
                      2.0,
                      gn * k_time,
                      0.2,
                      2.0 * gn * (1.0 - k_time));
    float bn = 8.0;
    float bf = flower(t,
                      6.0,
                      -3.0,
                      bn * k_time,
                      0.3,
                      2.0 * bn * (1.0 - k_time));
    vec3 clr = (sigma_delta(r0, rf) * vec3(0.75, 0.1, 0.3) +
                sigma_delta(r0, gf) * vec3(0.15, 0.5, 0.1) +
                sigma_delta(r0, bf) * vec3(0.1, 0.5, 0.4));
    fragColor = vec4(clamp(clr, 0.0, 1.0), 1.0);
}
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

